/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.chunk_loading.NewChunkTrackingGraph;
import qouteall.imm_ptl.core.chunk_loading.PerformanceLevel;
import qouteall.imm_ptl.core.chunk_loading.ServerPerformanceMonitor;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class ChunkVisibility {
    private static final LimitedLogger limitedLogger = new LimitedLogger(10);
    private static final int portalLoadingRange = 48;
    public static final int secondaryPortalLoadingRange = 16;

    public static ChunkLoader playerDirectLoader(ServerPlayer player) {
        return new ChunkLoader(new DimensionalChunkPos((ResourceKey<Level>)player.m_9236_().m_46472_(), player.m_146902_()), McHelper.getRenderDistanceOnServer(), true);
    }

    private static int getDirectLoadingDistance(int renderDistance, double distanceToPortal) {
        if (distanceToPortal < 5.0) {
            return renderDistance;
        }
        if (distanceToPortal < 15.0) {
            return renderDistance * 2 / 3;
        }
        return renderDistance / 3;
    }

    private static int getCappedLoadingDistance(Portal portal, ServerPlayer player, int targetLoadingDistance) {
        PerformanceLevel performanceLevel = NewChunkTrackingGraph.getPlayerInfo((ServerPlayer)player).performanceLevel;
        int cap1 = PerformanceLevel.getIndirectLoadingRadiusCap(performanceLevel);
        int cap2 = IPGlobal.indirectLoadingRadiusCap;
        int cap3 = PerformanceLevel.getIndirectLoadingRadiusCap(ServerPerformanceMonitor.getLevel());
        int cap = Math.min(cap1, cap2);
        if (portal.getScale() > 2.0) {
            cap *= 2;
        }
        int cappedLoadingDistance = Math.min(targetLoadingDistance, cap);
        return cappedLoadingDistance;
    }

    public static List<Portal> getNearbyPortals(ServerLevel world, Vec3 pos, Predicate<Portal> predicate, int radiusChunks, int radiusChunksForGlobalPortals) {
        List<Portal> result = McHelper.findEntitiesRough(Portal.class, (Level)world, pos, radiusChunks, predicate);
        for (Portal globalPortal : GlobalPortalStorage.getGlobalPortals((Level)world)) {
            double distance = globalPortal.getDistanceToNearestPointInPortal(pos);
            if (!(distance < (double)(radiusChunksForGlobalPortals * 16))) continue;
            result.add(globalPortal);
        }
        if (result.size() > 100) {
            limitedLogger.err("too many portal nearby " + String.valueOf(world) + String.valueOf(pos));
            Optional<Portal> nearest = result.stream().min(Comparator.comparingDouble(p -> p.getDistanceToNearestPointInPortal(pos)));
            return List.of(nearest.get());
        }
        return result;
    }

    private static ChunkLoader getGeneralDirectPortalLoader(ServerPlayer player, Portal portal) {
        if (portal.getIsGlobal()) {
            int renderDistance = Math.min(IPGlobal.indirectLoadingRadiusCap * 2, Math.max(2, McHelper.getRenderDistanceOnServer() - Math.floorDiv((int)portal.getDistanceToNearestPointInPortal(player.m_20182_()), 16)));
            return new ChunkLoader(new DimensionalChunkPos(portal.dimensionTo, new ChunkPos(BlockPos.m_274446_((Position)portal.transformPoint(player.m_20182_())))), renderDistance);
        }
        int renderDistance = McHelper.getRenderDistanceOnServer();
        double distance = portal.getDistanceToNearestPointInPortal(player.m_20182_());
        if (portal.scaling > 2.0 && distance < 5.0) {
            renderDistance = (int)(portal.getDestAreaRadiusEstimation() * 1.4 / 16.0);
        }
        return new ChunkLoader(new DimensionalChunkPos(portal.dimensionTo, new ChunkPos(BlockPos.m_274446_((Position)portal.getDestPos()))), ChunkVisibility.getCappedLoadingDistance(portal, player, ChunkVisibility.getDirectLoadingDistance(renderDistance, distance)));
    }

    private static ChunkLoader getGeneralPortalIndirectLoader(ServerPlayer player, Vec3 transformedPos, Portal portal) {
        int serverLoadingDistance = McHelper.getRenderDistanceOnServer();
        if (portal.getIsGlobal()) {
            int renderDistance = Math.min(IPGlobal.indirectLoadingRadiusCap, serverLoadingDistance / 3);
            return new ChunkLoader(new DimensionalChunkPos(portal.dimensionTo, new ChunkPos(BlockPos.m_274446_((Position)transformedPos))), renderDistance);
        }
        return new ChunkLoader(new DimensionalChunkPos(portal.dimensionTo, new ChunkPos(BlockPos.m_274446_((Position)portal.getDestPos()))), ChunkVisibility.getCappedLoadingDistance(portal, player, serverLoadingDistance / 4));
    }

    public static void foreachBaseChunkLoaders(ServerPlayer player, Consumer<ChunkLoader> func) {
        PerformanceLevel perfLevel = NewChunkTrackingGraph.getPlayerInfo((ServerPlayer)player).performanceLevel;
        int visiblePortalRangeChunks = PerformanceLevel.getVisiblePortalRangeChunks(perfLevel);
        int indirectVisiblePortalRangeChunks = PerformanceLevel.getIndirectVisiblePortalRangeChunks(perfLevel);
        ChunkLoader playerDirectLoader = ChunkVisibility.playerDirectLoader(player);
        func.accept(playerDirectLoader);
        List<Portal> nearbyPortals = ChunkVisibility.getNearbyPortals((ServerLevel)player.m_9236_(), player.m_20182_(), portal -> portal.m_6459_(player), visiblePortalRangeChunks, 256);
        for (Portal portal2 : nearbyPortals) {
            Level destinationWorld = portal2.getDestinationWorld();
            if (destinationWorld == null) continue;
            Vec3 transformedPlayerPos = portal2.transformPoint(player.m_20182_());
            func.accept(ChunkVisibility.getGeneralDirectPortalLoader(player, portal2));
            if (ChunkVisibility.isShrinkLoading()) continue;
            List<Portal> indirectNearbyPortals = ChunkVisibility.getNearbyPortals((ServerLevel)destinationWorld, transformedPlayerPos, p -> p.m_6459_(player), indirectVisiblePortalRangeChunks, 32);
            for (Portal innerPortal : indirectNearbyPortals) {
                func.accept(ChunkVisibility.getGeneralPortalIndirectLoader(player, transformedPlayerPos, innerPortal));
            }
        }
    }

    public static boolean isShrinkLoading() {
        return ServerPerformanceMonitor.getLevel() != PerformanceLevel.good;
    }
}

